define([
    'underscore',
    'modules/form/leave-confirmation/leave-confirmation-popup-view',
], function(_, LeaveConfirmationPopupView) {
    'use strict';

    describe('Leave Confirmation Popup', function() {
        var view;
        var $view;

        beforeEach(function() {
            view = new LeaveConfirmationPopupView({
                elAfterClose: '.element-for-focus',
                continue: _.noop,
            });

            $('body').append('<a class="element-for-focus" href="#"></a>');
            view.render();
            $view = view.$el;
        });

        afterEach(function() {
            view.destroy();
            $('.element-for-focus').remove();
        });

        it('has a heading', function() {
            expect($view.find('h2.ui-title').text()).toEqual('Exit Confirmation');
        });

        it('has a body', function () {
            expect($view.find('.ui-content p:first-of-type').text())
                .toEqual('You are about to leave New Appointment/Request form. Any changes you have made will be lost. Do you want to continue?');
        });

        it('has a yes button', function() {
            var yesBtn = $view.find('#leave-confirmation-yes-btn');
            expect(yesBtn.text()).toEqual('Yes');
        });

        it('has a no button', function() {
            var noBtn = $view.find('#leave-confirmation-no-btn');
            expect(noBtn.text()).toEqual('No');
        });
    });
});
